/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.content.ContentManager;
import jade.core.AID;
import jade.core.AgentToolkit;
import jade.core.LifeCycle;
import jade.core.Location;
import jade.core.MessageQueue;
import jade.core.Scheduler;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.midlet.MIDlet;

public class Agent
implements Runnable,
Serializable,
TimerListener {
    private static final long serialVersionUID = 3487495895819000L;
    public static final int AP_MIN = 0;
    public static final int AP_INITIATED = 1;
    public static final int AP_ACTIVE = 2;
    public static final int AP_IDLE = 3;
    public static final int AP_SUSPENDED = 4;
    public static final int AP_WAITING = 5;
    public static final int AP_DELETED = 6;
    public static final int AP_MAX = 13;
    private transient MessageQueue msgQueue = new MessageQueue();
    private transient AgentToolkit myToolkit;
    private String myName = null;
    private AID myAID = null;
    private String myHap = null;
    private transient Object stateLock = new Object();
    private transient Thread myThread;
    private transient TimerDispatcher theDispatcher;
    private Scheduler myScheduler;
    private transient AssociationTB pendingTimers = new AssociationTB();
    private int messageCounter = 0;
    private LifeCycle myLifeCycle = this.myActiveLifeCycle = new ActiveLifeCycle();
    private LifeCycle myBufferedLifeCycle;
    private LifeCycle myActiveLifeCycle;
    private transient LifeCycle myDeletedLifeCycle;
    private boolean terminating = false;
    public static MIDlet midlet;
    private boolean isInterrupted = false;
    private transient Object[] arguments = null;
    private ContentManager theContentManager = null;
    private transient Hashtable helpersTable;

    public void restartLater(Behaviour b, long millis) {
        if (millis <= 0L) {
            return;
        }
        Timer t = new Timer(System.currentTimeMillis() + millis, this);
        this.pendingTimers.addPair(b, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTimeOut(Timer t) {
        Behaviour b = null;
        TimerDispatcher timerDispatcher = this.theDispatcher;
        synchronized (timerDispatcher) {
            b = this.pendingTimers.getPeer(t);
            if (b != null) {
                this.pendingTimers.removeMapping(b);
            }
        }
        if (b != null) {
            b.restart();
        } else {
            System.out.println("Warning: No mapping found for expired timer " + t.expirationTime());
        }
    }

    public void notifyRestarted(Behaviour b) {
        Behaviour root;
        Timer t = this.pendingTimers.getPeer(b);
        if (t != null) {
            this.pendingTimers.removeMapping(b);
        }
        if ((root = b.root()).isRunnable()) {
            this.myScheduler.restart(root);
        }
    }

    public final AID getAMS() {
        return this.myToolkit.getAMS();
    }

    public final AID getDefaultDF() {
        return this.myToolkit.getDefaultDF();
    }

    public Agent() {
        this.myScheduler = new Scheduler(this);
        this.theDispatcher = TimerDispatcher.getTimerDispatcher();
    }

    public final void setArguments(Object[] args) {
        this.arguments = args;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public final String getLocalName() {
        return this.myName;
    }

    public final String getName() {
        if (this.myHap != null) {
            return this.myName + '@' + this.myHap;
        }
        return this.myName;
    }

    public final String getHap() {
        return this.myHap;
    }

    public final AID getAID() {
        return this.myAID;
    }

    void setAID(AID id) {
        this.myName = id.getLocalName();
        this.myHap = id.getHap();
        this.myAID = id;
    }

    synchronized void addPlatformAddress(String address) {
        if (this.myAID != null) {
            this.myAID = (AID)this.myAID.clone();
            this.myAID.addAddresses(address);
        }
    }

    synchronized void removePlatformAddress(String address) {
        if (this.myAID != null) {
            this.myAID = (AID)this.myAID.clone();
            this.myAID.removeAddresses(address);
        }
    }

    public Location here() {
        return this.myToolkit.here();
    }

    public void join() {
        block2: {
            if (this.myThread == null || !this.myThread.isAlive()) break block2;
            try {
                this.myThread.join();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public void setQueueSize(int newSize) throws IllegalArgumentException {
        this.msgQueue.setMaxSize(newSize);
    }

    public int getCurQueueSize() {
        return this.msgQueue.size();
    }

    public int getQueueSize() {
        return this.msgQueue.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStateTo(LifeCycle newLifeCycle) {
        boolean changed = false;
        newLifeCycle.setAgent(this);
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.myLifeCycle.equals(newLifeCycle) && this.myLifeCycle.transitionTo(newLifeCycle)) {
                this.myBufferedLifeCycle = this.myLifeCycle;
                this.myLifeCycle = newLifeCycle;
                changed = true;
            }
        }
        if (changed) {
            this.myLifeCycle.transitionFrom(this.myBufferedLifeCycle);
            if (!Thread.currentThread().equals(this.myThread)) {
                this.interruptThread();
            }
        }
    }

    public void restoreBufferedState() {
        this.changeStateTo(this.myBufferedLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveState(int newState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.myLifeCycle == this.myActiveLifeCycle) {
                int oldState = this.myLifeCycle.getState();
                if (newState != oldState) {
                    ((ActiveLifeCycle)this.myLifeCycle).setState(newState);
                }
            } else {
                throw new Interrupted();
            }
        }
    }

    public int getState() {
        return this.myLifeCycle.getState();
    }

    public void doSuspend() {
    }

    public void doActivate() {
    }

    public void doWait() {
        this.doWait(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(long millis) {
        if (Thread.currentThread().equals(this.myThread)) {
            this.setActiveState(5);
            MessageQueue messageQueue = this.msgQueue;
            synchronized (messageQueue) {
                try {
                    this.waitOn(this.msgQueue, millis);
                }
                catch (InterruptedException ie) {
                    if (this.myLifeCycle != this.myActiveLifeCycle && !this.terminating) {
                        throw new Interrupted();
                    }
                    System.out.println("Agent " + this.getName() + " interrupted while waiting");
                }
                this.setActiveState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWake() {
        Object object = this.stateLock;
        synchronized (object) {
            int previous = this.myLifeCycle.getState();
            if (previous == 5 || previous == 3) {
                this.setActiveState(2);
            }
        }
        if (this.myLifeCycle.isMessageAware()) {
            this.activateAllBehaviours();
            MessageQueue messageQueue = this.msgQueue;
            synchronized (messageQueue) {
                this.msgQueue.notifyAll();
            }
        }
    }

    public void doDelete() {
        if (this.myDeletedLifeCycle == null) {
            this.myDeletedLifeCycle = new DeletedLifeCycle();
        }
        this.changeStateTo(this.myDeletedLifeCycle);
    }

    void idle() throws InterruptedException {
        this.setActiveState(3);
        this.waitOn(this.myScheduler, 0L);
        this.setActiveState(2);
    }

    public final void run() {
        try {
            this.myLifeCycle.init();
            while (this.myLifeCycle.alive()) {
                try {
                    this.myLifeCycle.execute();
                    Thread.yield();
                }
                catch (JADESecurityException jse) {
                    System.out.println("JADESecurityException: " + jse.getMessage());
                }
                catch (InterruptedException ie) {
                }
                catch (InterruptedIOException ie) {
                }
                catch (Interrupted i) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            System.err.println("***  Uncaught Exception for agent " + this.myName + "  ***");
            t.printStackTrace();
        }
        this.terminating = true;
        this.myLifeCycle.end();
    }

    public void clean(boolean ok) {
        if (!ok) {
            System.out.println("ERROR: Agent " + this.myName + " died without being properly terminated !!!");
            System.out.println("State was " + this.myLifeCycle.getState());
        }
        this.myBufferedLifeCycle = this.myLifeCycle;
        this.myLifeCycle = this.myActiveLifeCycle;
        this.takeDown();
        this.pendingTimers.clear();
        this.myToolkit.handleEnd(this.myAID);
        this.myLifeCycle = this.myBufferedLifeCycle;
    }

    protected void setup() {
    }

    protected void takeDown() {
    }

    synchronized void powerUp(AID id, Thread t) {
        if (this.myThread == null) {
            this.myName = id.getLocalName();
            this.myHap = id.getHap();
            this.myAID = id;
            this.myToolkit.setPlatformAddresses(this.myAID);
            this.myThread = t;
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilWake(long millis) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            try {
                this.waitOn(this.msgQueue, millis);
            }
            catch (InterruptedException ie) {
                throw new Interrupted();
            }
        }
    }

    public void addBehaviour(Behaviour b) {
        b.setAgent(this);
        this.myScheduler.add(b);
    }

    public void removeBehaviour(Behaviour b) {
        this.myScheduler.remove(b);
        b.setAgent(null);
    }

    public final void send(ACLMessage msg) {
        try {
            msg.getSender().getName().charAt(0);
        }
        catch (Exception e) {
            msg.setSender(this.myAID);
        }
        this.myToolkit.handleSend(msg, this.myAID, true);
    }

    public final ACLMessage receive() {
        return this.receive(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACLMessage receive(MessageTemplate pattern) {
        ACLMessage msg = null;
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            Iterator messages = this.msgQueue.iterator();
            while (messages.hasNext()) {
                ACLMessage cursor = (ACLMessage)messages.next();
                if (pattern != null && !pattern.match(cursor)) continue;
                this.msgQueue.remove(cursor);
                msg = cursor;
                break;
            }
        }
        return msg;
    }

    public final ACLMessage blockingReceive() {
        return this.blockingReceive(null, 0L);
    }

    public final ACLMessage blockingReceive(long millis) {
        return this.blockingReceive(null, millis);
    }

    public final ACLMessage blockingReceive(MessageTemplate pattern) {
        return this.blockingReceive(pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACLMessage blockingReceive(MessageTemplate pattern, long millis) {
        ACLMessage msg = null;
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            msg = this.receive(pattern);
            long timeToWait = millis;
            while (msg == null) {
                long startTime = System.currentTimeMillis();
                if (Thread.currentThread().equals(this.myThread)) {
                    this.doWait(timeToWait);
                } else {
                    this.waitUntilWake(timeToWait);
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                msg = this.receive(pattern);
                if (millis != 0L && (timeToWait -= elapsedTime) <= 0L) break;
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putBack(ACLMessage msg) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            this.msgQueue.addFirst(msg);
        }
    }

    final void setToolkit(AgentToolkit at) {
        this.myToolkit = at;
    }

    final void resetToolkit() {
        this.myToolkit = null;
    }

    private void activateAllBehaviours() {
        this.myScheduler.restartAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postMessage(ACLMessage msg) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            if (msg != null) {
                this.msgQueue.addLast(msg);
                this.doWake();
                ++this.messageCounter;
            }
        }
    }

    public ContentManager getContentManager() {
        if (this.theContentManager == null) {
            this.theContentManager = new ContentManager();
        }
        return this.theContentManager;
    }

    public ServiceHelper getHelper(String serviceName) throws ServiceException {
        ServiceHelper se = null;
        if (this.helpersTable == null) {
            this.helpersTable = new Hashtable();
        }
        if ((se = (ServiceHelper)this.helpersTable.get(serviceName)) == null) {
            se = this.myToolkit.getHelper(this, serviceName);
            if (se != null) {
                se.init(this);
                this.helpersTable.put(serviceName, se);
            } else {
                throw new ServiceException("Null helper");
            }
        }
        return se;
    }

    public String getProperty(String key, String aDefault) {
        String sval;
        String val = this.myToolkit.getProperty(key, aDefault);
        if ((val == null || val.equals(aDefault)) && (sval = System.getProperty(key)) != null) {
            val = sval;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptThread() {
        Agent agent = this;
        synchronized (agent) {
            this.isInterrupted = true;
            MessageQueue messageQueue = this.msgQueue;
            synchronized (messageQueue) {
                this.msgQueue.notifyAll();
            }
            Scheduler scheduler = this.myScheduler;
            synchronized (scheduler) {
                this.myScheduler.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitOn(Object lock, long millis) throws InterruptedException {
        Agent agent = this;
        synchronized (agent) {
            if (this.isInterrupted) {
                this.isInterrupted = false;
                throw new InterruptedException();
            }
        }
        lock.wait(millis);
        Agent agent2 = this;
        synchronized (agent2) {
            if (this.isInterrupted) {
                this.isInterrupted = false;
                throw new InterruptedException();
            }
        }
    }

    private class DeletedLifeCycle
    extends LifeCycle {
        private static final long serialVersionUID = 11112L;

        private DeletedLifeCycle() {
            super(6);
        }

        public void end() {
            Agent.this.clean(true);
        }

        public boolean alive() {
            return false;
        }
    }

    private class ActiveLifeCycle
    extends LifeCycle {
        private static final long serialVersionUID = 11111L;

        private ActiveLifeCycle() {
            super(1);
        }

        public void setState(int s) {
            this.myState = s;
        }

        public void init() {
            Agent.this.setActiveState(2);
            Agent.this.setup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            Behaviour currentBehaviour = Agent.this.myScheduler.schedule();
            int oldMsgCounter = Agent.this.messageCounter;
            currentBehaviour.actionWrapper();
            if (oldMsgCounter != Agent.this.messageCounter && !currentBehaviour.isRunnable()) {
                currentBehaviour.restart();
            }
            if (currentBehaviour.done()) {
                currentBehaviour.onEnd();
                Agent.this.myScheduler.remove(currentBehaviour);
                currentBehaviour = null;
            } else {
                Scheduler scheduler = Agent.this.myScheduler;
                synchronized (scheduler) {
                    if (!currentBehaviour.isRunnable()) {
                        Agent.this.myScheduler.block(currentBehaviour);
                        currentBehaviour = null;
                    }
                }
            }
        }

        public void end() {
            Agent.this.clean(false);
        }

        public boolean transitionTo(LifeCycle to) {
            if (!Agent.this.terminating) {
                this.myState = 2;
                return true;
            }
            return false;
        }

        public void transitionFrom(LifeCycle from) {
            Agent.this.activateAllBehaviours();
        }

        public boolean isMessageAware() {
            return true;
        }
    }

    private static class TBPair {
        private Timer myTimer;
        private long expirationTime;
        private Behaviour myBehaviour;
        private Agent owner;

        public TBPair() {
            this.expirationTime = -1L;
        }

        public TBPair(Agent a, Timer t, Behaviour b) {
            this.owner = a;
            this.myTimer = t;
            this.expirationTime = t.expirationTime();
            this.myBehaviour = b;
        }

        public void setTimer(Timer t) {
            this.myTimer = t;
        }

        public Timer getTimer() {
            return this.myTimer;
        }

        public Behaviour getBehaviour() {
            return this.myBehaviour;
        }

        public void setBehaviour(Behaviour b) {
            this.myBehaviour = b;
        }

        public Agent getOwner() {
            return this.owner;
        }

        public void setOwner(Agent o) {
            this.owner = o;
            this.createTimerIfNeeded();
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(long when) {
            this.expirationTime = when;
            this.createTimerIfNeeded();
        }

        private void createTimerIfNeeded() {
            if (this.myTimer == null && this.owner != null && this.expirationTime > 0L) {
                this.myTimer = new Timer(this.expirationTime, this.owner);
            }
        }
    }

    private class AssociationTB {
        private Hashtable BtoT = new Hashtable();
        private Hashtable TtoB = new Hashtable();

        private AssociationTB() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                Enumeration e = this.timers();
                while (e.hasMoreElements()) {
                    Timer t = (Timer)e.nextElement();
                    Agent.this.theDispatcher.remove(t);
                }
                this.BtoT.clear();
                this.TtoB.clear();
            }
        }

        public void addPair(Behaviour b, Timer t) {
            TBPair pair = new TBPair(Agent.this, t, b);
            this.addPair(pair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPair(TBPair pair) {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                if (pair.getOwner() == null) {
                    pair.setOwner(Agent.this);
                }
                pair.setTimer(Agent.this.theDispatcher.add(pair.getTimer()));
                TBPair old = this.BtoT.put(pair.getBehaviour(), pair);
                if (old != null) {
                    Agent.this.theDispatcher.remove(old.getTimer());
                    this.TtoB.remove(old.getTimer());
                }
                this.TtoB.put(pair.getTimer(), pair);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMapping(Behaviour b) {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                TBPair pair = (TBPair)this.BtoT.remove(b);
                if (pair != null) {
                    this.TtoB.remove(pair.getTimer());
                    Agent.this.theDispatcher.remove(pair.getTimer());
                }
            }
        }

        public Timer getPeer(Behaviour b) {
            TBPair pair = (TBPair)this.BtoT.get(b);
            if (pair != null) {
                return pair.getTimer();
            }
            return null;
        }

        public Behaviour getPeer(Timer t) {
            TBPair pair = (TBPair)this.TtoB.get(t);
            if (pair != null) {
                return pair.getBehaviour();
            }
            return null;
        }

        private Enumeration timers() {
            return this.TtoB.keys();
        }
    }

    public static class Interrupted
    extends Error {
    }
}

